/*
 * Decompiled with CFR 0.152.
 */
package com.gopivotal.cloudfoundry.tomcat.lifecycle;

import com.gopivotal.cloudfoundry.tomcat.lifecycle.StandardStateParser;
import com.gopivotal.cloudfoundry.tomcat.lifecycle.StateParser;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardContext;

public final class ApplicationStartupFailureDetectingLifecycleListener
implements LifecycleListener {
    private static final int EXIT_CODE = 404;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Runtime runtime;
    private final StateParser stateParser = new StandardStateParser();

    public ApplicationStartupFailureDetectingLifecycleListener() {
        this(Runtime.getRuntime());
    }

    ApplicationStartupFailureDetectingLifecycleListener(Runtime runtime) {
        this.runtime = runtime;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getType() == "after_start") {
            Container lifecycle = (Container)event.getLifecycle();
            for (Container child : lifecycle.findChildren()) {
                if (!(child instanceof StandardContext)) continue;
                this.checkContext((StandardContext)child);
            }
        }
    }

    private void checkContext(StandardContext context) {
        Object state = this.getState(context);
        if (!this.stateParser.isRunning(state)) {
            String applicationName = this.getApplicationName(context);
            this.logger.severe(String.format("Error: Application '%s' failed (state = %s): see Tomcat's logs for details. Halting Tomcat.", applicationName, state));
            System.err.flush();
            System.out.flush();
            this.runtime.halt(404);
        }
    }

    private String getApplicationName(StandardContext context) {
        String displayName = context.getDisplayName();
        if (displayName == null) {
            return context.getName();
        }
        return displayName;
    }

    private Object getState(StandardContext context) {
        try {
            Method getStateMethod = StandardContext.class.getMethod("getState", new Class[0]);
            return getStateMethod.invoke((Object)context, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

